<?php
// $Id$

/**
 * @file
 * Suntech BuySafe menu items.
 *
 */

function uc_suntech_buysafe_complete($cart_id = 0) {
  $errcode = check_plain($_GET['errcode']);
  $order_id = check_plain($_GET['note1']); 
  $buysafeord = check_plain($_GET['buysafeord']);
  
  watchdog('suntech_buysafe', '訂單通知：訂單 !order_id, BuySafe 單號 !buysafeord, 錯誤碼 !errcode.', 
    array('!order_id' => $order_id, '!buysafeord' => $buysafeord,'!errcode' => $errcode));
    
  $success = array_search($errcode, array('0', '00', '000')) >= 0 ? true : false;
  if (!$success) {
    print t('訂單付款沒有成功。訂單：%order_id, 錯誤代碼：!errcode, 錯誤訊息: !errmsg2', 
      array('%order_id' => $order_id, '!errcode' => $errocde, '!errmsg2' => check_plain($_GET['errmsg2'])));
    exit();
  }
  
  $order = uc_order_load($order_id);

  if ($order === FALSE || uc_order_status_data($order->order_status, 'state') != 'in_checkout') {
    print t('未知的錯誤訊息。訂單編號不存在或是訂單狀能不處於付款狀能中。請與我們連繫確認您的付款。謝謝！');
    exit();
  }

  $paid_total = intval($_GET['MN']);
  if ($order->order_total != $paid_total) {
    print t('訂單金額 !order_amt 不等於付款金額 !paid_amt, 請與我們連繫確認您的付款。謝謝！', 
      array('!order_amt' => $order->order_total, '!paid_amt' => $paid_total));
    exit();
  }

  // Empty that cart...
  uc_cart_empty(uc_cart_get_id());

  // Save changes to order without it's completion (it will be on finalization step)
  uc_order_save($order);
  
  $url = 'cart/suntech-buysafe/finalize/'. $order->order_id;

  // Javascript redirect on the finalization page.
  $output = '<script type="text/javascript">window.location = "'. url($url, array('absolute' => TRUE)) .'";</script>';

  // Text link for users without Javascript enabled.
  $output .= l(t('請按這裡完成訂單.'), $url, array('absolute' => TRUE));

  print $output;
  exit();
}


function uc_suntech_buysafe_finalize() {
  $order = uc_order_load(arg(3));

  // Add a comment to let sales team know this came in through the site.
  uc_order_comment_save($order->order_id, 0, t('Order created through website.'), 'admin');

  $output = uc_cart_complete_sale($order, variable_get('uc_new_customer_login', FALSE));

  $page = variable_get('uc_cart_checkout_complete_page', '');

  if (!empty($page)) {
    drupal_goto($page);
  }

  return $output;
}


function uc_suntech_buysafe_fail($cart_id = 0) {
//  $opresult = array();
//  
//  $opresult[] = check_plain($_GET['buysafeord']);
//  $opresult[] = check_plain($_GET['web']);
//  $opresult[] = check_plain($_GET['MN']);
//  $opresult[] = check_plain($_GET['webname']);
//  $opresult[] = check_plain(($_GET['Name']));
//  $opresult[] = check_plain($_GET['note1']);
//  $opresult[] = check_plain($_GET['note2']);
//  $opresult[] = check_plain(($_GET['OrderInfo']));
//  $opresult[] = check_plain(($_GET['ApproveCode']));
//  $opresult[] = check_plain(($_GET['errcode']));
//  $opresult[] = check_plain(($_GET['errmsg']));
//  $opresult[] = check_plain(($_GET['errmsg2']));
//  
//  print_r($opresult);

  $errcode = check_plain($_GET['errcode']);
  $order_id = check_plain($_GET['note1']); 
  $buysafeord = check_plain($_GET['buysafeord']);
  
  watchdog('suntech_buysafe', '[錯誤]訂單通知：訂單 !order_id, BuySafe 單號 !buysafeord, 錯誤碼 !errcode.', 
    array('!order_id' => $order_id, '!buysafeord' => $buysafeord, '!errcode' => $errcode));
    
  unset($_SESSION['cart_order']);

  drupal_set_message(t('[錯誤]訂單 !order_id, 錯誤碼 !errcode, 錯誤訊息: !errmsg2.<br/>' .
    '請重新確認您的訂單並請重新下單。謝謝。', 
    array('!order_id' => $order_id, '!buysafeord' => $buysafeord, '!errcode' => $errcode, 
    '!errmsg2' => $_GET['errmsg2'])));

  drupal_goto(variable_get('uc_paypal_wps_cancel_return_url', 'cart'));    
}

